import flixel.FlxG;
import openfl.Assets;
import funkin.menus.MainMenuState;
import funkin.backend.FunkinSprite;
import funkin.backend.system.Logs;
import flixel.group.FlxTypedGroup;
import hxvlc.flixel.FlxVideo;
import funkin.options.OptionsMenu;
import funkin.utils.CoolUtil;
import Sys;
import funkin.editors.ui.UIState;
import funkin.editors.EditorPicker;
import flixel.group.FlxGroup.FlxTypedGroup;
import funkin.game.PlayState;
import funkin.savedata.FunkinSave;
import flixel.text.FlxTextAlign;

importScript("data/scripts/progressionHandler");

var curMember:Int;
var canSelect:Bool = false;
var thumbnail:FunkinSprite;
var thegray:FlxSprite = new FlxSprite().makeGraphic(FlxG.width, FlxG.height, 0xFF161616);
var overlay:FlxSprite = new FlxSprite().loadGraphic("images/menus/storymenu/story_overlaygradient.png");
var scroll:FlxSound = FlxG.sound.load(Paths.sound("menu/scroll"));
var intendedScore:Int = 0;
var pfpBorder:FunkinSprite;

function create() {

    FlxG.mouse.visible = false;
    FlxG.save.data.wk5canPlay = false;
    thumbnails = new FlxTypedGroup();
    for (i in 0...5){
        thumbnail = new FunkinSprite();
        switch(i){
            case 0:
                thumbnail.frames = Paths.getSparrowAtlas("menus/storymenu/animated thumbnails/week1menu"); //weegee
                thumbnail.animation.addByPrefix("idle","weegeemenu", 24, false);
                thumbnail.setGraphicSize(FlxG.width,720);
                //thumbnail.animation.play("idle");
                thumbnail.visible = false;
            case 1:
                thumbnail.frames = Paths.getSparrowAtlas("menus/storymenu/animated thumbnails/week2menu"); //myboy
                thumbnail.animation.addByPrefix("idle","week2menu", 24, true);
                thumbnail.setGraphicSize(FlxG.width,720);
                thumbnail.visible = false;
            case 2:
                thumbnail.frames = Paths.getSparrowAtlas("menus/storymenu/animated thumbnails/week3menu"); //octagon
                thumbnail.animation.addByPrefix("idle","week3menu", 24, true);
                thumbnail.setGraphicSize(FlxG.width,720);
                thumbnail.visible = false;
            case 3:
                thumbnail.frames = Paths.getSparrowAtlas("menus/storymenu/animated thumbnails/week4menu"); //pingas
                thumbnail.animation.addByPrefix("idle","week4menu", 24, true);
                thumbnail.setGraphicSize(FlxG.width,720);
                thumbnail.visible = false;
            case 4:
                thumbnail.frames = Paths.getSparrowAtlas("menus/storymenu/animated thumbnails/week5menu"); //sanic
                thumbnail.animation.addByPrefix("idle","week5menu", 24, true);
                thumbnail.setGraphicSize(FlxG.width,720);
                thumbnail.visible = false;
        }
        thumbnail.screenCenter();
        thumbnail.y -= 1;
        thumbnails.add(thumbnail);
    }
    add(thumbnails);
    thegray.alpha = 0.001;
    add(thegray);
    add(overlay);
    thumbnails.members[0].visible = true;
    curMember = 0;


    arrows = new FlxTypedGroup();
    for (i in 0...2){
        arrow = new FunkinSprite();
        arrow.frames = Paths.getSparrowAtlas("menus/storymenu/arrow");
	    arrow.animation.addByPrefix("idle","arrow idle", 0, false);
        arrow.animation.addByPrefix("hit","arrow hit", 24, false);
        arrow.screenCenter();

        switch(i){
            case 0:
                arrow.x -= 100;
            case 1:
                arrow.flipX = true;
                arrow.x += 100;
        }
        //arrow.y -= 50;
        arrow.animation.play("idle");
        arrows.add(arrow);
    }
    
    add(arrows);

    play = new FunkinSprite();
    play.frames = Paths.getSparrowAtlas("menus/storymenu/playbutton");
    play.animation.addByPrefix("idle","playbutton shimmer", 24, false);
    play.animation.addByPrefix("idleNoshimmer","playbutton idle", 24, false);
    play.animation.addByPrefix("play","playbutton enter", 24, false);
    play.animation.addByPrefix("playIdle","playbutton enter idle", 0, false);
    play.animation.play("idle");
    play.screenCenter();
    //play.y -= 50;
    add(play);

    barStuff = new FlxTypedGroup();

    bar = new FlxSprite();
    bar.makeGraphic(FlxG.width,180,FlxColor.WHITE);
    bar.screenCenter();
    bar.y += 270;
    barStuff.add(bar);

    pfps = new FlxTypedGroup();
    for (i in 0...5){
        pfp = new FunkinSprite();
        switch(i){
            case 0:
                pfp.frames = Paths.getSparrowAtlas("menus/storymenu/youtube pfps/Weegee_Profile_Pic"); //weegee
                pfp.animation.addByPrefix("idle","Weegee", 24, true);
                //pfp.setGraphicSize(FlxG.width,720);
                pfp.animation.play("idle");
                pfp.visible = false;
            case 1:
                pfp.frames = Paths.getSparrowAtlas("menus/storymenu/youtube pfps/King_Profile_Pic"); //myboy
                pfp.animation.addByPrefix("idle","King", 24, true);
                //pfp.setGraphicSize(FlxG.width,720);
                pfp.animation.play("idle");
                pfp.visible = false;
            case 2:
                pfp.frames = Paths.getSparrowAtlas("menus/storymenu/youtube pfps/Octogonapus_Profile_Pic"); //octagon
                pfp.animation.addByPrefix("idle","OCTOGONAPUS", 24, true);
                //pfp.setGraphicSize(FlxG.width,720);
                pfp.animation.play("idle");
                pfp.visible = false;
            case 3:
                pfp.frames = Paths.getSparrowAtlas("menus/storymenu/youtube pfps/Robotnik_Profile_Pic"); //pingas
                pfp.animation.addByPrefix("idle","Robotnik", 24, true);
                //pfp.setGraphicSize(FlxG.width,720);
                pfp.animation.play("idle");
                pfp.visible = false;
            case 4:
                pfp.frames = Paths.getSparrowAtlas("menus/storymenu/youtube pfps/Sanic_Profile_Pic"); //sanic
                pfp.animation.addByPrefix("idle","Sanic", 24, true);
                //pfp.setGraphicSize(FlxG.width,720);
                pfp.animation.play("idle");
                pfp.visible = false;
        }
        pfp.scale.set(0.5,0.5);
        pfp.screenCenter();
        pfp.x -= 400;
        pfp.y += 270;
        pfp.antialiasing = true;
        pfps.add(pfp);
    }
    barStuff.add(pfps);
    pfpBorder = new FunkinSprite(26, 576).loadGraphic("images/menus/storymenu/story_pfpborder.png");
    pfpBorder.scale.set(1.2,1.2);
    barStuff.add(pfpBorder);
    pfps.members[0].visible = true;

    weekText = new FunkinText(10, 10, 0, "YTPMV -", 36);
    weekText.setFormat(Paths.font("vcr.ttf"), 32);
    add(weekText);

    pfpText1 = new FunkinText(150, 560, 0, "From: ", 36);
    pfpText1.setFormat(Paths.font("vcr.ttf"), 32, FlxColor.GRAY);
    barStuff.add(pfpText1);

    pfpText2 = new FunkinText(240, 560, 0, "bees", 36);
    pfpText2.setFormat(Paths.font("vcr.ttf"), 32, FlxColor.BLUE);
    barStuff.add(pfpText2);
    
    scoreText1 = new FunkinText(600, 600, 0, "Score:", 36);
    scoreText1.setFormat(Paths.font("vcr.ttf"), 50, FlxColor.BLACK, FlxTextAlign.RIGHT);
    //scoreText1.alignment = FlxTextAlign.RIGHT;
    scoreText1.bold = true;
    barStuff.add(scoreText1);

    CoolUtil.playMenuSong();

    add(barStuff);

	delay = new FlxTimer().start(0.5, () -> {
		if (FlxG.save.data.unlockedFolder && !FlxG.save.data.searchPopupHappen) searchPopup();
		canSelect = true;
	});
    
    //for(i in ["weegee", "faces of evil","octogonapus","robotnik","major league"]){
        //weekScore = FunkinSave.getWeekHighscore("weegee", "normal").score;
        //trace(weekScore);
    //}
}
function searchPopup() {
    FlxG.save.data.popupName = "congration";
    FlxG.save.data.searchPopupHappen = true;
	openSubState(new ModSubState("customStates/PopupSubstate"));
	persistentUpdate = false;
	persistentDraw = true;
}

function update(){
    if (intendedScore == 0) scoreText1.visible = false; else scoreText1.visible = true;

    loadScore();
    scoreText1.text = "Score: "+intendedScore;
    play.animation.finishCallback = function (name:String){
        if(name == 'idle'){
            play.animation.play("idleNoshimmer");
            new FlxTimer().start(1.3, function(tmr:FlxTimer)
                {
                    if (canSelect) play.animation.play("idle");
                });
        }   
        if(name == 'play'){
            //play.animation.play("playIdle");
        }
    }
    if (canSelect){
    if (controls.BACK) 
        {
            skipTransition = false;
            whiteTransition = false;
            FlxG.switchState(new MainMenuState());

        }

    if (controls.LEFT_P && curMember > 0) 
        {
            arrows.members[0].animation.play("hit", true); 
            FlxTween.cancelTweensOf(thegray);
            thegray.alpha = 1;
            if (curMember > 0) switchWeek(-1);
            FlxTween.tween(thegray, {alpha: 0.001}, 0.2);
        }
    if (controls.RIGHT_P && curMember < 4) 
        {
            arrows.members[1].animation.play("hit", true); 
            FlxTween.cancelTweensOf(thegray);
            thegray.alpha = 1;
            if (curMember < 4) switchWeek(1);
            FlxTween.tween(thegray, {alpha: 0.001}, 0.2);
        }
    if (controls.ACCEPT) {
        if (curMember == 4) {
            if (curMember == 4 && FlxG.save.data.wk5canPlay) {
                FlxG.save.data.wk5canPlay = false;
                selectWeek();
            } else {
                FlxG.save.data.popupName = "warning";
                openSubState(new ModSubState("customStates/PopupSubstate"));
                persistentUpdate = false;
                persistentDraw = true;
            }
            //The sanic Warning Pop up
            //selectWeek();
        } else selectWeek();
    }
    }

    if (curMember == 4) pfps.members[4].visible = true;
    else pfps.members[4].visible = false;

    switch(curMember){
        case 0:
            weekText.text = 'YTPMV 1: The Spaghetti Encounter';
            pfpText2.text = 'Weegee';
        case 1:
            weekText.text = 'YTPMV 2: The Faces of MAH BOY';
            pfpText2.text = 'Zelda CDI';
        case 2:
            weekText.text = 'YTPMV 3: The Lazer Competition';
            pfpText2.text = 'Doctor Octogonapus';
        case 3:
            weekText.text = 'YTPMV 4: Mean Bean Rap Machine';
            pfpText2.text = 'Robotnik';
        case 4:
            weekText.text = 'YTPMV 5: CUMMON, STEP IT UP!!!';
            pfpText2.text = 'Xx_Sanic_xX';
    }
}

function switchWeek(change:Int){
    scroll.play(true);

    if (change == -1) {
        curMember -= 1;
        thumbnails.members[curMember].visible = true;
        thumbnails.members[curMember - change].visible = false;

        pfps.members[curMember].visible = true;
        pfps.members[curMember - change].visible = false;
    }
    if (change == 1) {
        curMember += 1;
        thumbnails.members[curMember].visible = true;
        thumbnails.members[curMember + change].visible = false;

        pfps.members[curMember].visible = true;
        pfps.members[curMember + change].visible = false;
    }

}

function selectWeek() {
    canSelect = false;
    FlxG.sound.music.stop();
    play.animation.play("play", true);
    skipTransition = false;
    whiteTransition = false;
    arrows.members[0].visible = false;
    arrows.members[1].visible = false;
    if (FlxG.mouse.visible) FlxG.mouse.visible = false;
    FlxG.sound.play(Paths.sound('menu/confirm'));
    fade = new FlxTimer().start(2.2, () ->
	{
    FlxG.camera.fade(FlxColor.BLACK, 0.4, false);
    });
    switch(curMember){
        case 0:
            PlayState.loadWeek({
            name: "weegee",
            id: "weegee",
            sprite: null,
            chars: [null, null, null],
            songs: [{name: 'Anchored', hide: false}, {name: 'Ravioli', hide: false}],
            difficulties: ['normal']
            }, "normal");

            thumbnails.members[0].animation.play("idle");
        case 1:
            PlayState.loadWeek({
            name: "faces of evil",
            id: "faces of evil",
            sprite: null,
            chars: [null, null, null],
            songs: [{name: 'Blaster', hide: false}, {name: 'Richer', hide: false}],
            difficulties: ['normal']
            }, "normal");

            thumbnails.members[1].animation.play("idle");
        case 2:
            PlayState.loadWeek({
            name: "octogonapus",
            id: "octogonapus",
            sprite: null,
            chars: [null, null, null],
            songs: [{name: 'Firing', hide: false}, {name: 'Lazer', hide: false}],
            difficulties: ['normal']
            }, "normal");

            thumbnails.members[2].animation.play("idle");
        case 3:
            PlayState.loadWeek({
            name: "robotnik",
            id: "robotnik",
            sprite: null,
            chars: [null, null, null],
            songs: [{name: 'Snooping', hide: false}, {name: 'Pingas', hide: false}],
            difficulties: ['normal']
            }, "normal");

            thumbnails.members[3].animation.play("idle");
        case 4:
            PlayState.loadWeek({
            name: "major league",
            id: "major league",
            sprite: null,
            chars: [null, null, null],
            songs: [{name: 'No Scope', hide: false}, {name: 'Collateral', hide: false}],
            difficulties: ['normal']
            }, "normal");

            thumbnails.members[4].animation.play("idle");
    }
    for (i in 0...pfps.members.length ){
        FlxTween.tween(pfps.members[i], {y:pfps.members[i].y + 180}, 0.5, {ease: FlxEase.circInOut});
    }
    FlxTween.tween(bar, {y:bar.y + 180}, 0.5, {ease: FlxEase.circInOut});
    FlxTween.tween(pfpBorder, {y:pfpBorder.y + 180}, 0.5, {ease: FlxEase.circInOut});
    FlxTween.tween(pfpText1, {y:pfpText1.y + 180}, 0.5, {ease: FlxEase.circInOut});
    FlxTween.tween(pfpText2, {y:pfpText2.y + 180}, 0.5, {ease: FlxEase.circInOut});
    FlxTween.tween(scoreText1, {y:scoreText1.y + 180}, 0.5, {ease: FlxEase.circInOut});
    FlxTween.tween(weekText, {y:weekText.y - 50}, 0.5, {ease: FlxEase.circInOut});
    FlxTween.tween(overlay, {alpha: 0.001}, 0.5, {ease: FlxEase.circInOut});
    FlxTween.tween(play, {alpha: 0.001}, 0.5, {startDelay: 0.7, ease: FlxEase.circInOut});
    //thumbnails.members[curMember].animation.play("idle")
    new FlxTimer().start(2.7, function(tmr:FlxTimer)
	{
		FlxG.switchState(new PlayState());
	});
    //new FlxTimer().start(1, function(tmr:FlxTimer)
    //{
    
    //});
}

function loadScore() {
    switch(curMember){
        case 0:
            intendedScore = FunkinSave.getWeekHighscore("weegee", "normal").score;
        case 1:
            intendedScore = FunkinSave.getWeekHighscore("faces of evil", "normal").score;
        case 2:
            intendedScore = FunkinSave.getWeekHighscore("octogonapus", "normal").score;
        case 3:
            intendedScore = FunkinSave.getWeekHighscore("robotnik", "normal").score;
        case 4:
            intendedScore = FunkinSave.getWeekHighscore("major league", "normal").score;
    }
    return intendedScore;
}